/*
=======================================================================================
'Criaçaõ de trigger
'DT Revisão: 27/12/2023
'Revisado por: Willian José
'=======================================================================================
*/
--DROP TRIGGER SE EXISTIR
IF OBJECT_ID ('TRG_GT_CONFIG_CFOP_AUDIT', 'TR') IS NOT NULL
BEGIN
	DROP TRIGGER TRG_GT_CONFIG_CFOP_AUDIT
END
GO
--CRIAÇÃO DE TRIGGER
CREATE TRIGGER TRG_GT_CONFIG_CFOP_AUDIT
    ON GT_CONFIG_CFOP
    AFTER INSERT, UPDATE, DELETE
    AS
BEGIN
    DECLARE @jsonOld NVARCHAR(MAX), @jsonNew NVARCHAR(MAX), @userId INT
    SELECT @jsonOld = (SELECT * FROM deleted FOR JSON AUTO),
           @jsonNew = (SELECT * FROM inserted FOR JSON AUTO),
           @userId = SUSER_SNAME()
    INSERT INTO GT_CONFIG_AUDIT(OperationTime, TableName, OperationType, UserId, OldValues, NewValues)
    VALUES(GETDATE(), 'GT_CONFIG_CFOP',
           CASE
               WHEN @jsonOld IS NULL THEN 'I' -- Insert
               WHEN @jsonNew IS NULL THEN 'D' -- Delete
               ELSE 'U' -- Update
               END,
           @userId, @jsonOld, @jsonNew)
END